<?php

namespace UtillzCore\Inc\Src;

class Taxonomies {

    use \UtillzCore\Inc\Src\Traits\Singleton;

    function __construct() {

        // built-in taxonomies
        add_action( 'init', [ $this, 'register_taxonomies' ] );
        // custom taxonomies
        add_action( 'init', [ $this, 'register_custom_taxonomies' ] );

    }

    function register_taxonomies() {

        if( ! $category_slug = get_option('ulz_tax_category_slug') ) {
            $category_slug = 'listing-category';
        }

        // built-in taxonomy: category
        $labels = [
            'name'                => _x( 'Categories', 'Categories Singular Name', 'utillz-core' ),
            'singular_name'       => _x( 'Category', 'Categories Singular Name', 'utillz-core' ),
            'search_items'        => __( 'Search Categories', 'utillz-core' ),
            'all_items'           => __( 'All Categories', 'utillz-core' ),
            'parent_item'         => __( 'Parent Category', 'utillz-core' ),
            'parent_item_colon'   => __( 'Parent Category:', 'utillz-core' ),
            'edit_item'           => __( 'Edit Category', 'utillz-core' ),
            'update_item'         => __( 'Update Category', 'utillz-core' ),
            'add_new_item'        => __( 'Add New Category', 'utillz-core' ),
            'new_item_name'       => __( 'New Category Name', 'utillz-core' ),
            'menu_name'           => __( 'Categories', 'utillz-core' ),
        ];
        $args = [
            'hierarchical'        => true,
            'labels'              => $labels,
            'public'              => boolval( get_option('ulz_tax_category_public') ),
            'show_ui'             => true,
            'show_in_quick_edit'  => false,
            'meta_box_cb'         => false,
            'show_admin_column'   => false,
            'query_var'           => true,
            'rewrite'             => [
                'slug' => $category_slug
            ],
        ];
        register_taxonomy( 'ulz_listing_category', [ 'ulz_listing' ], $args );

        if( ! $tag_region = get_option('ulz_tax_region_slug') ) {
            $tag_region = 'listing-region';
        }

        // built-in taxonomy: region
        $labels = [
            'name'                => _x( 'Regions', 'Regions Singular Name', 'utillz-core' ),
            'singular_name'       => _x( 'Region', 'Regions Singular Name', 'utillz-core' ),
            'search_items'        => __( 'Search Regions', 'utillz-core' ),
            'all_items'           => __( 'All Regions', 'utillz-core' ),
            'parent_item'         => __( 'Parent Region', 'utillz-core' ),
            'parent_item_colon'   => __( 'Parent Region:', 'utillz-core' ),
            'edit_item'           => __( 'Edit Region', 'utillz-core' ),
            'update_item'         => __( 'Update Region', 'utillz-core' ),
            'add_new_item'        => __( 'Add New Region', 'utillz-core' ),
            'new_item_name'       => __( 'New Region Name', 'utillz-core' ),
            'menu_name'           => __( 'Regions', 'utillz-core' ),
        ];
        $args = [
            'hierarchical'        => true,
            'labels'              => $labels,
            'public'              => boolval( get_option('ulz_tax_region_public') ),
            'show_ui'             => true,
            'show_in_quick_edit'  => false,
            'meta_box_cb'         => false,
            'show_admin_column'   => false,
            'query_var'           => true,
            'rewrite'             => [
                'slug' => $tag_region
            ],
        ];
        register_taxonomy( 'ulz_listing_region', [ 'ulz_listing' ], $args );

        if( ! $tag_slug = get_option('ulz_tax_tag_slug') ) {
            $tag_slug = 'listing-tag';
        }

        // built-in taxonomy: tag
        $labels = [
            'name'                => _x( 'Tags', 'Taxonomy Singular Name', 'utillz-core' ),
            'singular_name'       => _x( 'Tag', 'Taxonomy Singular Name', 'utillz-core' ),
            'search_items'        => __( 'Search Tags', 'utillz-core' ),
            'all_items'           => __( 'All Tags', 'utillz-core' ),
            'parent_item'         => __( 'Parent Tag', 'utillz-core' ),
            'parent_item_colon'   => __( 'Parent Tag:', 'utillz-core' ),
            'edit_item'           => __( 'Edit Tag', 'utillz-core' ),
            'update_item'         => __( 'Update Tag', 'utillz-core' ),
            'add_new_item'        => __( 'Add New Tag', 'utillz-core' ),
            'new_item_name'       => __( 'New Tag Name', 'utillz-core' ),
            'menu_name'           => __( 'Tags', 'utillz-core' ),
        ];
        $args = [
            'hierarchical'        => false,
            'labels'              => $labels,
            'public'              => boolval( get_option('ulz_tax_tag_public') ),
            'show_ui'             => true,
            'show_in_quick_edit'  => false,
            'meta_box_cb'         => false,
            'show_admin_column'   => false,
            'query_var'           => true,
            'rewrite'             => [
                'slug' => $tag_slug
            ],
        ];
        register_taxonomy( 'ulz_listing_tag', [ 'ulz_listing', 'ulz_collection' ], $args );

    }

    function register_custom_taxonomies() {

        $custom_taxonomies = Ucore()->get_custom_taxonomies();
        if( is_array( $custom_taxonomies ) ) {
            foreach( $custom_taxonomies as $custom_taxonomy ) {

                $labels = [
                    'name'                => $custom_taxonomy->name,
            		'singular_name'       => _x( 'Item', 'Taxonomy Singular Name', 'utillz-core' ),
            		'search_items'        => __( 'Search Items', 'utillz-core' ),
            		'all_items'           => __( 'All Items', 'utillz-core' ),
            		'parent_item'         => __( 'Parent Item', 'utillz-core' ),
            		'parent_item_colon'   => __( 'Parent Item:', 'utillz-core' ),
            		'edit_item'           => __( 'Edit Item', 'utillz-core' ),
            		'update_item'         => __( 'Update Item', 'utillz-core' ),
            		'add_new_item'        => __( 'Add New Item', 'utillz-core' ),
            		'new_item_name'       => __( 'New Item Name', 'utillz-core' ),
            		'menu_name'           => $custom_taxonomy->name,
            	];
            	$args = [
            		'hierarchical'        => true,
            		'labels'              => $labels,
                    'public'              => isset( $custom_taxonomy->tax_public ) && boolval( $custom_taxonomy->tax_public ),
            		'show_ui'             => true,
            		'show_in_quick_edit'  => false,
            		'meta_box_cb'         => false,
            		'show_admin_column'   => false,
            		'query_var'           => true,
            		'rewrite'             => [
                        'slug' => $custom_taxonomy->slug
                    ],
            	];

                if( $custom_taxonomy->slug ) {
                    register_taxonomy( Ucore()->prefix( $custom_taxonomy->slug ), [ 'ulz_listing' ], $args );
                }
            }
        }
    }
}
